# /// script
# requires-python = ">=3.10"
# dependencies = ["pandas", "openpyxl"]
# ///

import sys
from pathlib import Path

import pandas as pd

if len(sys.argv) < 2:
    print("Usage: uv run dta2csv.py <file.dta> [--xlsx]")
    sys.exit(1)

xlsx = "--xlsx" in sys.argv
src = Path([a for a in sys.argv[1:] if not a.startswith("--")][0])

if not src.exists():
    print(f"Error: {src} not found")
    sys.exit(1)

df = pd.read_stata(src)

if xlsx:
    dst = src.with_suffix(".xlsx")
    print(f"Converting {src} -> {dst} ...")
    df.to_excel(dst, index=False)
else:
    dst = src.with_suffix(".csv")
    print(f"Converting {src} -> {dst} ...")
    df.to_csv(dst, index=False)

print("Done.")
